package de.DroolsGUI;
import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;

import javax.swing.JButton;

import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.SwingConstants;


public class DroolsGUIView extends JPanel implements ActionListener {
	
	private static final long serialVersionUID = 1L;
	
	private DroolsGUIModel model = new DroolsGUIModel();
	private JTextArea jTextArea_OutputArea;
	private JLabel jLabel_step3;
	private JLabel jLabel_step2;
	private JLabel jLabel_step1;
	private JButton jButton_clearConsole;
	private JButton jButton_removeAllInput;
	private JButton jButton_errorCheck;
	private JScrollPane jScrollPane_OutputArea;

	private JButton jButton_FireAllRules;
	private JButton jButton_DRLInput;
	private JLabel jLabel_Output;

		
	public DroolsGUIView() {
		super();
		setOpaque(true); //Note that we set the JPanel that sits on the Content Pane to opaque (opaque being the opposite of transparent/see through). This is because some operating systems (notably GTK+) set the JPanel to be transparent as default. If we left this line out, our program would display itself properly on some OS, and not in others. 
		
		initGUI();

		setOutputStream();
		setErrorStream();
	}
	
	private void initGUI() {
		try {
			AnchorLayout thisLayout = new AnchorLayout();
			setLayout(thisLayout);
			setPreferredSize(new java.awt.Dimension(584, 420));
			{
				jLabel_step3 = new JLabel();
				this.add(jLabel_step3, new AnchorConstraint(194, 607, 232, 375, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL));
				jLabel_step3.setText("Step 3:");
				jLabel_step3.setPreferredSize(new java.awt.Dimension(135, 16));
				jLabel_step3.setHorizontalAlignment(SwingConstants.RIGHT);
				jLabel_step3.setForeground(new java.awt.Color(0,128,0));
			}
			{
				jLabel_step2 = new JLabel();
				this.add(jLabel_step2, new AnchorConstraint(122, 607, 160, 375, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL));
				jLabel_step2.setText("Step 2:");
				jLabel_step2.setPreferredSize(new java.awt.Dimension(135, 16));
				jLabel_step2.setHorizontalAlignment(SwingConstants.RIGHT);
				jLabel_step2.setForeground(new java.awt.Color(228,202,16));
			}
			{
				jLabel_step1 = new JLabel();
				this.add(jLabel_step1, new AnchorConstraint(53, 608, 91, 375, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL));
				jLabel_step1.setText("Step 1:");
				jLabel_step1.setPreferredSize(new java.awt.Dimension(136, 16));
				jLabel_step1.setHorizontalAlignment(SwingConstants.RIGHT);
				jLabel_step1.setForeground(new java.awt.Color(255,0,0));
			}
			{
				jTextArea_OutputArea = new JTextArea();
				jTextArea_OutputArea.setEditable(false);
				jTextArea_OutputArea.setFont(new Font("Serif", Font.PLAIN, 12));
				jTextArea_OutputArea.setLineWrap(true);
				jTextArea_OutputArea.setWrapStyleWord(true);
				
				jScrollPane_OutputArea = new JScrollPane(jTextArea_OutputArea);
				jScrollPane_OutputArea.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
				this.add(jScrollPane_OutputArea, new AnchorConstraint(298, 980, 972, 21, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL));
			}
			{
				jLabel_Output = new JLabel();
				this.add(jLabel_Output, new AnchorConstraint(232, 471, 270, 21, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL));
				jLabel_Output.setText("Ausgabefenster:");
				jLabel_Output.setPreferredSize(new java.awt.Dimension(263, 16));
				jLabel_Output.setHorizontalAlignment(SwingConstants.LEFT);
			}

			{
				jButton_DRLInput = new JButton();
				this.add(jButton_DRLInput, new AnchorConstraint(44, 951, 103, 629, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL));
				jButton_DRLInput.setText(".drl File Input");
				jButton_DRLInput.setPreferredSize(new java.awt.Dimension(188, 25));
				jButton_DRLInput.setToolTipText("Geben Sie eine oder mehrere Drools Rule Files (.drl) an");
				jButton_DRLInput.addActionListener(this);
			}
			{
				jButton_FireAllRules = new JButton();
				this.add(jButton_FireAllRules, new AnchorConstraint(184, 951, 244, 629, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL));
				jButton_FireAllRules.setText("Fire all Rules");
				jButton_FireAllRules.setPreferredSize(new java.awt.Dimension(188, 25));
				jButton_FireAllRules.setEnabled(false);
				jButton_FireAllRules.setToolTipText("Feuert alle Regeln die zutreffen");
				jButton_FireAllRules.addActionListener(this);
			}
			{
				jButton_errorCheck = new JButton();
				this.add(jButton_errorCheck, new AnchorConstraint(113, 951, 172, 629, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL));
				jButton_errorCheck.setText("Check for Compile Errors");
				jButton_errorCheck.setPreferredSize(new java.awt.Dimension(188, 25));
				jButton_errorCheck.setEnabled(false);
				jButton_errorCheck.setToolTipText("Testet die eingegebenen Dateien auf Compiler Fehler und zeigt diese im Ausgabefenster an falls vorhanden");
				jButton_errorCheck.addActionListener(this);
			}
			{
				jButton_clearConsole = new JButton();
				this.add(jButton_clearConsole, new AnchorConstraint(113, 322, 172, 21, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL));
				jButton_clearConsole.setText("Ausgabefenster leeren");
				jButton_clearConsole.setToolTipText("Entfernt den Text aus dem Ausgabefenster");
				jButton_clearConsole.setPreferredSize(new java.awt.Dimension(176, 25));
				jButton_clearConsole.addActionListener(this);
			}
			{
				jButton_removeAllInput = new JButton();
				this.add(jButton_removeAllInput, new AnchorConstraint(44, 322, 103, 21, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL, AnchorConstraint.ANCHOR_REL));
				jButton_removeAllInput.setText("Remove all Input");
				jButton_removeAllInput.setPreferredSize(new java.awt.Dimension(176, 25));
				jButton_removeAllInput.setToolTipText("Entfernt alle eingegebenen Dateien");
				jButton_removeAllInput.setEnabled(false);
				jButton_removeAllInput.addActionListener(this);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		
		
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		
		if (e.getSource().equals(jButton_FireAllRules)) {
			
			model.fireRules();
			
		}
		if (e.getSource().equals(jButton_DRLInput)) {
			JFileChooser fc = new JFileChooser();
			JDialog dialogFile = new JDialog();
			dialogFile.setLayout(null);
			dialogFile.setSize(400, 300);
			fc.showOpenDialog(dialogFile);
			try{
				System.out.println("Selected File: " + fc.getSelectedFile().getPath());
				model.addKnowledgeToBuilder(fc.getSelectedFile().getPath());
				jButton_errorCheck.setEnabled(true);
				jButton_removeAllInput.setEnabled(true);
			}catch(NullPointerException ex){}
		}
		if(e.getSource().equals(jButton_errorCheck)){
			if(!model.errorCheck()){
				jButton_FireAllRules.setEnabled(true);
				model.createKnowledgeBase();
				System.out.println("Kein Compiler Error!");
			}

			
		}
		if(e.getSource().equals(jButton_clearConsole)){
			jTextArea_OutputArea.setText("");
		}
		if(e.getSource().equals(jButton_removeAllInput)){
			jButton_removeAllInput.setEnabled(false);
			jButton_FireAllRules.setEnabled(false);
			jButton_errorCheck.setEnabled(false);
			model.removeAllInput();
		}
	}
	
    public void newStringToTextArea(String str,boolean newline) {
    	if(newline == true)
    		jTextArea_OutputArea.append(str + "\n");
    	else
    		jTextArea_OutputArea.append(str);
    }
    
    public void setOutputStream(){
		PrintStream myOutStream = new PrintStream(System.out) {
	        @Override
	        public void println(String s) {
	        	newStringToTextArea(s,true);
	        }
	        
	        @Override
	        public void print(String s) {
	        	newStringToTextArea(s,false);
	        }
	    };
	    System.setOut(myOutStream);
    }
    
    public void setErrorStream(){
	    PrintStream myErrStream = new PrintStream(System.err){
	    	@Override
	    	public void println(String s) {
	    		newStringToTextArea(s,true);
	    	}
        
	    	@Override
	    	public void print(String s) {
	    		newStringToTextArea(s+"\n",false);
	    	}
	    };
	    System.setErr(myErrStream);
    }
}
